package net.w_horse.excelpojo.xml.tag;

public enum Use {
	NONE("none"), OPTIONAL("optional"), REQUIRED("required");

	private String value;
	private Use(String value) {
		this.value = value;
	}
	public String getValue() {
		return this.value;
	}
	public static String getTagName() {
		return "use";
	}

	public static boolean equalas(Use elementName, String expr) {
		Use retrieveTypeExpr = getElement(expr);
		return (retrieveTypeExpr == elementName);
	}

	public static boolean equalsIgnoreCase(Use elementName, String expr) {
		Use retrieveTypeExpr = getElementIgnoreCase(expr);
		return (retrieveTypeExpr == elementName);
	}
	public boolean equals(String expr) {
		return getValue().equals(expr);
	}
	public boolean equalsIgnoreCase(String expr) {
		return getValue().equalsIgnoreCase(expr);
	}

	private static Use getElement(String elementName) {
		for (Use retrieveType : values()) {
			if (retrieveType.equals(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
	private static Use getElementIgnoreCase(String elementName) {
		for (Use retrieveType : values()) {
			if (retrieveType.equalsIgnoreCase(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
}
